/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml;

import com.google.common.collect.Lists;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.xml.ConversionException;
import cz.insophy.inplan.xml.InvalidXmlException;
import cz.insophy.inplan.xml.SuperplanConverter;
import cz.insophy.inplan.xml.SuperplanConverterChain;
import cz.insophy.inplan.xml.XmlSource;
import cz.insophy.inplan.xml.XsltSuperplanConverter;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class SuperplanVersionSupport {
    public static final int CURRENT_SUPERPLAN_VERSION_MAJOR = 5;
    public static final int CURRENT_SUPERPLAN_VERSION_MINOR = 0;
    public static final String SUPERPLAN_VERSION_PREFIX = "http://www.insophy.cz/inplan/plan/";
    public static final String SUPERPLAN_VERSION_SUFFIX = ".x";
    public static final String CURRENT_SUPERPLAN_VERSION_FQ = "http://www.insophy.cz/inplan/plan/5.x";
    public static final String CURRENT_SUPERPLAN_VERSION = "5.0";
    public static final String VERSION_0_NAMESPACE = "http://www.insophy.cz/inplan/plan";

    private SuperplanVersionSupport() {
    }

    private static SuperplanConverterChain getConverterChain(int fromVersion) {
        if (fromVersion >= 5) {
            return null;
        }
        ArrayList<SuperplanConverter> converters = Lists.newArrayList();
        for (int i = fromVersion; i < 5; ++i) {
            converters.add(new XsltSuperplanConverter(i));
        }
        return new SuperplanConverterChain(converters);
    }

    private static String parseSourceNamespace(XmlSource source) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
        XMLStreamReader reader = source.getReader(xmlInputFactory);
        reader.nextTag();
        String namespace = reader.getNamespaceURI();
        source.reset();
        return namespace;
    }

    private static int parseSourceNamespaceVersion(XmlSource source) throws XMLStreamException, InvalidXmlException {
        String namespace = SuperplanVersionSupport.parseSourceNamespace(source);
        if (namespace.trim().isEmpty() || namespace.equals(VERSION_0_NAMESPACE)) {
            return 0;
        }
        String versionString = namespace;
        versionString = versionString.replace(SUPERPLAN_VERSION_PREFIX, "");
        versionString = versionString.replace(SUPERPLAN_VERSION_SUFFIX, "");
        int version = 0;
        try {
            version = Integer.valueOf(versionString);
        }
        catch (NumberFormatException e) {
            throw new InvalidXmlException("'" + versionString + "' found instead of plan version.");
        }
        return version;
    }

    public static int isCompareWithCurrentVersion(XmlSource source) throws XMLStreamException, InvalidXmlException {
        int sourceVersion = SuperplanVersionSupport.parseSourceNamespaceVersion(source);
        return Comparators.compare(sourceVersion, 5);
    }

    public static XmlSource convertToCurrent(XmlSource source) throws XMLStreamException, ConversionException, InvalidXmlException {
        int sourceVersion = SuperplanVersionSupport.parseSourceNamespaceVersion(source);
        SuperplanConverterChain converterChain = SuperplanVersionSupport.getConverterChain(sourceVersion);
        if (converterChain == null) {
            throw new ConversionException();
        }
        return converterChain.convert(source);
    }
}

